
#!/bin/bash
export datasets1="Cora CiteSeer PubMed OGBN-Arxiv"
export datasets2="OGBN-Arxiv"
export missing_rates="0.99 0.999 0.9999 1.0"
export missing_rates_reverse="0.7 0.6"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2

# Strcutural - Products
for missing_rate in $missing_rates_reverse
do
python main.py --embedder GOODIE_2 --dataset OGBN-Products --include_neighbors True --missing_rate ${missing_rate} --n_runs 3 --lp_alpha 0.99 --lamb 1e-5 --normalize_label_mat False --gpu ${gpu}
done